package gov.va.vinci.dart.dms.biz;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestContent extends BusinessIntegrationTest {
	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		Repository repo = Repository.findById(1);
		Assert.assertNotNull(repo);
		Assert.assertEquals(repo.getId(), 1);
		
		Content content = Content.create("pdf", repo.getId());
		Assert.assertNotNull(content);
		Assert.assertTrue(content.getId() > 0);
		
		Content cont2 = Content.findById(content.getId());
		Assert.assertNotNull(cont2);
		Assert.assertTrue(cont2.getId() > 0);
		Assert.assertEquals(cont2, content);
		
		List<Content> cList = Content.listByRepository(1);
		Assert.assertNotNull(cList);
		Assert.assertTrue(cList.size() > 0);
		Assert.assertTrue(cList.contains(content));
	}
	
	/*
	List<Content> listByRepository(final int repositoryId);
	 */
}
